<?php
	/*Read parameters*/
	$book_id=$_GET["bid"];
	$page_id=$_GET["pid"];
	
	/* Some constants. The names are pretty much self-explanatory */
	$number_of_subimages_X=4;
	$number_of_subimages_Y=6;
	
	/*Just check if the file actually exists and make sure nobody tries to smuggle code in through GET*/
	if(!is_numeric($book_id) || !is_numeric($page_id) || !file_exists ( $book_id.$page_id.".gif" ))
		die("Illegal Book or Page specified");
	
	/*Calculate a magic number 0-99 from page and book id. Use an appropriate hash function, Do not make it random.*/
	$magic_num=abs(($book_id+$page_id));
	
	/*Set $magic_num as the basis for the pseudo-random number generator. This way, we get always the same random numbers for the same page-id and book-id*/
	mt_srand($magic_num);
	
	/* Load the page image using appropriate means */
	$image=imagecreatefromgif( $book_id.$page_id.".gif"  );
	$image_w=imagesx($image);
	$image_h=imagesy($image);
	
	/* Choose a transparent color. Right now this defaults to index 255 which is usually white */
	$trans_color_index=255;
	imagecolortransparent($image,$trans_color_index) ;
	
	/* Fill an array with some coordinates that we're going to use to produce our sub-images */
	$coords=array();
	$cell_dimensions_x=$image_w/$number_of_subimages_X;
	$cell_dimensions_y=$image_h/$number_of_subimages_Y;
	for($y=0;$y<=$number_of_subimages_Y;$y++){
		$coords[$y]=array();
		for($x=0;$x<=$number_of_subimages_X;$x++){
			$coords[$y][$x]=array();
			
			if($y==0) $coords[$y][$x]["y"]=0;
			else if($y>=$number_of_subimages_Y) $coords[$y][$x]["y"]=$image_h;
			else $coords[$y][$x]["y"]= floor($cell_dimensions_y*$y+mt_rand(0,$cell_dimensions_y)-$cell_dimensions_y/2);
			
			if($x==0) $coords[$y][$x]["x"]=0;
			else if($x>=$number_of_subimages_X) $coords[$y][$x]["x"]=$image_w;
			else $coords[$y][$x]["x"]= floor($cell_dimensions_x*$x+mt_rand(0,$cell_dimensions_x)-$cell_dimensions_x/2);
			
		}
	}
	
	/* Generate the padding data */
	$subpic_padding=array();
	for($y=0;$y<$number_of_subimages_Y;$y++){
		$subpic_padding[$y]=array();
		for($x=0;$x<$number_of_subimages_X;$x++){
			$subpic_padding[$y][$x]=array();
			$subpic_padding[$y][$x]["x0"]=mt_rand(4,12);
			$subpic_padding[$y][$x]["y0"]=mt_rand(4,12);
			$subpic_padding[$y][$x]["x1"]=mt_rand(4,12);
			$subpic_padding[$y][$x]["y1"]=mt_rand(4,12);
		}
	}
?>
